/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.platform;

import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.GLWrapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;

public final class RenderCore {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Graphics");
    public static int glCapabilitiesErrors;
    static boolean sInitialized;
    static boolean sIgnoreFormatError;
    private static Thread sRenderThread;

    public static void initBackend() {
        ModernUI.LOGGER.info(MARKER, "Backend Library: LWJGL {}", (Object)Version.getVersion());
        if (GLFW.glfwSetErrorCallback(RenderCore::callbackError) != null || !GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW");
        }
    }

    private static void callbackError(int errorCode, long descPtr) {
        if (errorCode == 65545 && sIgnoreFormatError) {
            return;
        }
        String desc = descPtr == 0L ? "" : MemoryUtil.memUTF8((long)descPtr);
        ModernUI.LOGGER.error(MARKER, "GLFW Error: 0x{}, {}", (Object)Integer.toHexString(errorCode), (Object)desc);
    }

    public static void ensureRenderThread() {
        if (Thread.currentThread() != sRenderThread) {
            throw new IllegalStateException("Not called from render thread");
        }
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == sRenderThread;
    }

    public static void interruptThread() {
        sRenderThread.interrupt();
    }

    public static synchronized void initialize() {
        GLCapabilities caps;
        if (sInitialized) {
            return;
        }
        sRenderThread = Thread.currentThread();
        try {
            caps = GL.getCapabilities();
        }
        catch (IllegalStateException e) {
            caps = GL.createCapabilities();
        }
        GLWrapper.initialize(caps);
        sInitialized = true;
    }

    public static boolean isInitialized() {
        return sInitialized;
    }

    @Nonnull
    public static ByteBuffer readRawBuffer(InputStream stream) throws IOException {
        ByteBuffer buffer;
        if (stream instanceof FileInputStream) {
            FileChannel channel = ((FileInputStream)stream).getChannel();
            buffer = MemoryUtil.memAlloc((int)((int)channel.size() + 1));
            while (channel.read(buffer) != -1) {
            }
        } else {
            ReadableByteChannel channel = Channels.newChannel(stream);
            buffer = MemoryUtil.memAlloc((int)8192);
            while (channel.read(buffer) != -1) {
                if (buffer.remaining() != 0) continue;
                buffer = MemoryUtil.memRealloc((ByteBuffer)buffer, (int)(buffer.capacity() << 1));
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readStringASCII(InputStream stream) {
        ByteBuffer buffer = null;
        try {
            buffer = RenderCore.readRawBuffer(stream);
            int len = buffer.position();
            buffer.rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)buffer, (int)len);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (buffer != null) {
                MemoryUtil.memFree((Buffer)buffer);
            }
        }
        return null;
    }

    static {
        sInitialized = false;
        sIgnoreFormatError = false;
    }
}

